import datetime

def calc_easter(year):
    a = year % 19
    b = year % 4
    c = year % 7
    k = year / 100
    p = (8 * k + 13) / 25
    q = k / 4
    M = (15 + k - p - q) % 30
    d = (19 * a + M) % 30
    N = (4 + k - q) % 7
    e = (2 * b + 4 * c + 6 * d + N) % 7
    easter_monday = (22 + d + e) - 1
    start = datetime.datetime.strptime("01.03." + str(year), "%d.%m.%Y")
    easter = start + datetime.timedelta(days=round(easter_monday))
    return easter.strftime('%d.%m.%Y')